//Lab 1 : Observe the effect of change in time constant of the first-order systems.
//------------------------------------------------------------------
// Problem Statement: Compare step response of 
// G1=1/(2s+1), G2=1/(s+1) and
// G3=1/(4s+1)
//------------------------------------------------------------------
// Operating System OSX (Mac) 10.14.6
// Scilab Version 6.1.0
//------------------------------------------------------------------

xdel(winsid()) // close the figure windows
clear; // clear the workspace
clc; // clear the console
//------------------------------------------------------------------
// system representation

s=%s  //Laplace operator

//system with various time constants.

G1=syslin('c',1/(2*s+1))     //system 1 represented by G1(s)=1/(2s+1)
G2=syslin('c',1/(s+1))       //system 2 represented by G2(s)=1/(s+1)
G3=syslin('c',1/(4*s+1))     //system 3 represented by G3(s)=1/(4s+1)

//------------------------------------------------------------------
// Unit step response
u=1
t=0:0.2:15             // Simulation time
c1=csim('step',t,G1*u)  // Response of system G1(s)=1/(2s+1)
c2=csim('step',t,G2*u)  // Response of system G2(s)=1/(s+1)
c3=csim('step',t,G3*u)  // Response of system G3(s)=1/(4s+1)

//plots 

plot(t,c1,t,c2,'r-',t,c3,'LineWidth',2)

// plot of response value at one time-constant
plot(2,0.6321,'o',1,0.6321,'ro',4,0.6321,'o','LineWidth',2)
plot(t,0.6321,'--','LineWidth',1.5)
xgrid

//Title, labels and grid to the figure
legend('Time constant 2 sec .for G1','Time constant 1 sec. for G2', 'Time constant 4 sec. for G3',4)
title('Responses of first-order systems' ,'fontsize',2)
xlabel('Time t (sec.)','fontsize',2)
ylabel('c(t)','fontsize',2)
